/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.preferencesdialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.nooj4nlp.gui.components.CursorChangeEffect;
import net.nooj4nlp.gui.dialogs.PreferencesDialog;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.io.FilenameUtils;

public class EditLexActionListener
implements ActionListener {
    private PreferencesDialog dialog = null;
    private JLabel lLexDoc = null;
    private JLabel lSynDoc = null;
    private boolean lexicalContext;

    public EditLexActionListener(PreferencesDialog dialog, JLabel lLexDoc, JLabel lSynDoc, boolean lexicalContext) {
        this.dialog = dialog;
        this.lLexDoc = lLexDoc;
        this.lSynDoc = lSynDoc;
        this.lexicalContext = lexicalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String fullname = "";
        fullname = this.lexicalContext ? this.lLexDoc.getText() : this.lSynDoc.getText();
        if (fullname == "") {
            return;
        }
        File f = new File(fullname);
        if (!f.exists()) {
            return;
        }
        String ext = FilenameUtils.getExtension(fullname);
        try {
            if (ext.equalsIgnoreCase("jnod") || ext.equalsIgnoreCase(".bin")) {
                this.dialog.setVisible(false);
                String fullname2 = FilenameUtils.getFullPath(fullname) + System.getProperty("file.separator") + FilenameUtils.getBaseName(fullname) + ".dic";
                File f1 = new File(fullname2);
                if (!f1.exists()) {
                    JOptionPane.showMessageDialog(this.dialog, "Cannot find dictionary source file " + fullname2);
                    this.dialog.setVisible(true);
                    return;
                }
                JOptionPane.showMessageDialog(this.dialog, "Remember to recompile the dictionary in Lab after having edited it");
                CursorChangeEffect.setCustomCursor(3);
                String lg = FilenameUtils.getPath(fullname) + FilenameUtils.getBaseName(fullname) + "." + "nog";
                File f2 = new File(lg);
                if (f2.exists()) {
                    DictionaryEditorShell formDictionary = new DictionaryEditorShell();
                    boolean success = formDictionary.getController().loadFromFile(fullname2);
                    if (!success) {
                        CursorChangeEffect.setCustomCursor(0);
                        JOptionPane.showMessageDialog(this.dialog, "Dictionary file corrupted? Cannot load it");
                        return;
                    }
                    Launcher.getDesktopPane().add(formDictionary);
                    formDictionary.setVisible(true);
                    this.dialog.setVisible(false);
                    GrammarEditorShell gEditor = new GrammarEditorShell(lg);
                    Launcher.getDesktopPane().add(gEditor);
                    gEditor.getController().LoadGrammar(lg, false);
                    if (gEditor.getController().grammar == null) {
                        CursorChangeEffect.setCustomCursor(0);
                        this.dialog.setVisible(true);
                        JOptionPane.showMessageDialog(this.dialog, "Grammar file corrupted? Cannot load it");
                        gEditor.setVisible(true);
                    }
                } else {
                    DictionaryEditorShell formDictionary = new DictionaryEditorShell();
                    boolean success = formDictionary.getController().loadFromFile(fullname2);
                    if (!success) {
                        CursorChangeEffect.setCustomCursor(0);
                        JOptionPane.showMessageDialog(this.dialog, "Dictionary file corrupted? Cannot load it");
                        return;
                    }
                    Launcher.getDesktopPane().add(formDictionary);
                    formDictionary.setVisible(true);
                    this.dialog.setVisible(false);
                }
            } else if (ext.equals("nog") || ext.equals("nom") || ext.equals(".grm")) {
                this.dialog.setVisible(false);
                GrammarEditorShell gEditor = new GrammarEditorShell(fullname);
                Launcher.getDesktopPane().add(gEditor);
                gEditor.getController().LoadGrammar(fullname, false);
                if (gEditor.getController().grammar == null) {
                    this.dialog.setVisible(true);
                    CursorChangeEffect.setCustomCursor(0);
                    return;
                }
                gEditor.setVisible(true);
                this.dialog.setVisible(false);
            }
        }
        finally {
            CursorChangeEffect.setCustomCursor(0);
        }
    }
}

